#include <stdio.h>
#include "TcpEngine.h"
#include <string.h>

class ChatFramingStrategy: public IFramingStrategy
{
protected:
    virtual int processData(char* buffer, size_t size, FullMessageInfo& info)
    {
        if (info.buffer == 0)
        {
            info.buffer = new char[size];
        }
        else
        {
            char* newbuf = new char[size + info.size];
            memcpy(newbuf, info.buffer, info.size);
            delete info.buffer;
            info.buffer = newbuf;
        }
        int i2 = info.currentIndex;
        for (int i = 0; i < size; i++)
        {
            if (buffer[i] == ';')
            {
                info.buffer[i2] = 0;
                info.size += i2;
                info.complete = true;
                if (info.size == 0) return -1;
                return i+1; // return index of next char
            }
            else if (buffer[i] != '\r' && buffer[i] != '\n')
            {
                info.buffer[i2] = buffer[i];
                i2++;
            }
        }

        info.size += i2;
        info.currentIndex = info.size;
        return size;
    }
};



class ChatServerEngine: public TcpEngine
{
public:
    ChatServerEngine():TcpEngine(new ClientFactory<ChatFramingStrategy>(this))
    {
    }

protected:

    virtual void onClientConnected(TcpClient* client)
    {
        printf("Client Connected\r\n");
        clients[client] = client;
    }

    virtual void onClientDisconnected(TcpClient* client)
    {
        printf("Client Disconnected\r\n");
        clients.erase(client);
    }

    virtual void onClientMessage(TcpClient* client, char* buffer, size_t size)
    {
        printf("Message: %s\r\n",buffer);
        for (auto& it : clients)
        {
            char* buf = new char[size+2];
            memcpy(buf,buffer,size);
            buf[size] = '\r';
            buf[size+1] = '\n';
            if (it.first != client) it.first->sendData(buf,size+2,false);
        }
        delete buffer;
    }

private:
    std::map<TcpClient*,TcpClient*> clients;
};




int main(int argc, char** argv)
{
    ChatServerEngine engine;
    engine.init(5555,"127.0.0.1",10);


    if (!engine.start())
    {
        printf("Could not start server\r\n");
        return -1;
    }

    getchar();

    engine.stop();
}

