#include "TcpEngine.h"

TcpEngine::TcpEngine(IClientFactory *factory)
{
    this->clientFactory = factory;
    this->tcpServer = 0;
}

TcpEngine::~TcpEngine()
{
    if (this->tcpServer != 0) delete this->tcpServer;
    if (this->clientFactory != 0) delete this->clientFactory;
}

void TcpEngine::init(int port, std::string bindAddr, int maxConnections)
{
    this->tcpServer = new TcpServer(this->clientFactory,5555, std::string("127.0.0.1"), 10);
}

bool TcpEngine::start()
{
    if (this->tcpServer == 0) return false;
    return this->tcpServer->start();
}

void TcpEngine::stop()
{
    if (this->tcpServer == 0) return;
    this->tcpServer->stop();
}

