#include "dwn.h"
#include "osapi.h"
#include "ets_sys.h"
#include "os_type.h"
#include "user_config.h"
#include "user_interface.h"
#include "gpio.h"
#include "mem.h"
#include "espconn.h"
#include "string.h"

#define SSID "AwesomeSSID"
#define PASSWORD "YeahRight!"
#define HEARTBEAT_INTERVAL 5000

static struct espconn tcp_config;
static esp_tcp tcp_connection;
static struct espconn* client=0;
static struct espconn multicast;
static volatile os_timer_t heartbeat;
static char chipid[12];
static recv_handler receive_handler;
static connect_handler new_connection_handler;
static char advertise[256];

void send_data(char* buffer, uint16 len)
{
    if (client == 0) return;

    espconn_send(client,buffer,len);
}

void ICACHE_FLASH_ATTR init_wifi(char ssid[32], char password[64])
{
    wifi_set_phy_mode(PHY_MODE_11B);
    os_printf("Will connect [%s] [%s]\r\n",ssid,password);
    struct station_config station_config;
    wifi_set_opmode(1); // station mode. will connect to AP
    os_memset(&station_config.ssid, 0, 32);
    os_memset(&station_config.password, 0, 64);
    station_config.bssid_set = 0; 
    
    os_memcpy(&station_config.ssid, ssid, 32);
    os_memcpy(&station_config.password, password, 64);
    wifi_station_set_config(&station_config);
//    wifi_station_set_auto_connect(false);
//    wifi_station_set_reconnect_policy(true);
}

uint32 ICACHE_FLASH_ATTR parse_number(char* data, uint16 len, uint32* value)
{
    uint32 size = 0;
    uint32 mul = 1;
    *value = 0;
    while (len)
    {
        char c = (*data)-48;
        data++;
        len--;

        if (c > 9) return size;
        size++;
        *value *= mul;
        *value += c;
        mul = 10;
    }
    return size;
}





static void ICACHE_FLASH_ATTR client_recv_handler(void* arg, char* data, uint16 len)
{
    receive_handler((struct espconn*)arg, data, len);
}

static void ICACHE_FLASH_ATTR client_sent_handler(void *arg)
{
    struct espconn* client_connection=(struct espconn*)arg;
}

static void ICACHE_FLASH_ATTR client_recon_handler(void *arg, sint8 err)
{
    struct espconn* client_connection=(struct espconn*)arg;
    if (client == client_connection) client = 0;
}

static void ICACHE_FLASH_ATTR client_disconnect_handler(void *arg)
{
    struct espconn* client_connection=(struct espconn*)arg;
    if (client == client_connection) client = 0;
}


static void ICACHE_FLASH_ATTR on_tcp_connection(void *arg)
{
    struct espconn *new_connection=arg;
    if (client != 0)
    {
        // Dicsonnect previous client
        espconn_disconnect(client);
    }

    espconn_regist_recvcb(new_connection, client_recv_handler);
    espconn_regist_sentcb(new_connection, client_sent_handler);
    espconn_regist_reconcb(new_connection, client_recon_handler);
    espconn_regist_disconcb(new_connection, client_disconnect_handler);
    client = new_connection;

    new_connection_handler(new_connection);
}

void heartbeat_handler(void *arg)
{
    os_printf("HB\r\n");
    os_memcpy(multicast.proto.udp->remote_ip, (char[]){224,242,242,242}, 4);
    multicast.proto.udp->remote_port = 242;
    espconn_send(&multicast, advertise, os_strlen(advertise));

    if (client!=0)
    {
        espconn_send(client,"yo!\r\n",5);
    }
}

static void ICACHE_FLASH_ATTR init_tcp_server(uint16 port)
{
    tcp_config.type=ESPCONN_TCP;
    tcp_config.state=ESPCONN_NONE;
    tcp_connection.local_port=port;
    tcp_config.proto.tcp=&tcp_connection;
    espconn_regist_connectcb(&tcp_config, on_tcp_connection);
    espconn_accept(&tcp_config);
}

void init_server(uint16 port, char* name, recv_handler rh,connect_handler ch)
{
    os_sprintf(chipid,"%d",system_get_chip_id());
    init_wifi(SSID,PASSWORD);
    init_tcp_server(port);

    strcpy(advertise,"{\"name\":\"");
    strcat(advertise,name);
    strcat(advertise,"\",\"id\":");
    strcat(advertise,chipid);
    strcat(advertise,"}");

    receive_handler = rh;
    new_connection_handler = ch;

    // Setup the multicast connection
    multicast.type = ESPCONN_UDP;
    multicast.proto.udp = (esp_udp*)os_zalloc(sizeof(esp_udp));
    multicast.proto.udp->local_port = espconn_port();

    os_memcpy(multicast.proto.udp->remote_ip, (char[]){224,242,242,242}, 4);
    multicast.proto.udp->remote_port = 242;
    espconn_create(&multicast);

    // Timer
    os_timer_disarm(&heartbeat);
    os_timer_setfn(&heartbeat, (os_timer_func_t *)heartbeat_handler, 0);
    os_timer_arm(&heartbeat, HEARTBEAT_INTERVAL, 1);
}
