#include "spi.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include "lcd2.h"
#include "global.h"
#define outp(val,port) port = val
#define inp(port) port

#define SPISTATE_IDLE 0
#define SPISTATE_RECEIVING 1
#define SPISTATE_WAITPROCESSING 200
static volatile char buf[128];
static volatile unsigned char qin;
static volatile unsigned char qout;
static volatile uint8_t spiState=0;
static volatile uint8_t currentCommand=255;

extern struct LedStatus leds[3];

/*
protocol:
    led: 1,ledNumber,action,param
        action: 1= blink, param = count
                2=steady, param: 0=off, 1=on
    write LCD: 2,row,16char

    when the master wants to send abyte, it must check if the slave is ready first.
    this is done by writing a dummy byte (255) and when the the slave returns SPISTATE_IDLE
    then the master can send.

*/

void initSPI()
{
    spiState = SPISTATE_IDLE;
    //set ourself as slave
    DDRB  = 0b01000000; // miso as output
    SPCR  = 0b11000010;  // interrupt inabled, osc/64: this has no effect on the slave
}


uint8_t spiHandler(){
    SPDR=0; // clear the return byte. Overwrite with proper response later
    uint8_t cmd;

    cmd = SPDR;
    SPDR = spiState;

    if (spiState == SPISTATE_IDLE)
    {
        qin = 0;
        if (cmd==1)
        {
            qout=3;     // LED command, we expect 3 data byte (led,action,param)
            spiState = SPISTATE_RECEIVING;
        } 
        else if (cmd ==2)       // LCD writing
        {
            qout=17;    // LCD command, we expect 17 data byte (1 position, 16 char)
            spiState = SPISTATE_RECEIVING;
        }
        else if (cmd==254)
        {
            // reset LCD
            initLCD();
        }

        currentCommand=cmd;
    }

    else if (spiState == SPISTATE_RECEIVING)
    {
        buf[qin] = cmd;
        qin++;
        if (qin==qout)
        {
            // wait for main thread to process this
            spiState = SPISTATE_WAITPROCESSING;
        }
    } 

    return 0;
}


void processSPICommand()
{
    if (spiState != SPISTATE_WAITPROCESSING) return;

    if (currentCommand==1)
    {
        if (buf[0]>=0&&buf[0]<3)
        {
            if (buf[1]==1)
            {
                leds[buf[0]].status=LEDSTATUS_BLINK;
                leds[buf[0]].blinkCount=buf[2];
            } else if (buf[1]==2)
            {
                leds[buf[0]].status=buf[2]?LEDSTATUS_ON:LEDSTATUS_OFF;
            }
        }
        // LED command
    }
    else if (currentCommand==2)
    {
        if (buf[0]==0 || buf[0]==1)
        {
            gotoXY(0, buf[0]);
            buf[18]=0;
            writeLCD((char*)&buf[1]);
        }
    }

    // we processed the command. Now go back to IDLE.
    spiState = SPISTATE_IDLE;
}

