#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include "lcd2.h"
#include "spi.h"
#include "global.h"

struct LedStatus leds[3];
static unsigned char timerCounter=61;
static uint16_t blinkCount=0;
#define TIMER0_PRESCALER 0b00000101 //(16M/1024)
#define TIMER0_OVERFLOW 0   // 61 interupt per seconds
#define F_OSC 16000000                  /* oscillator-frequency in Hz */

SIGNAL(SPI_STC_vect)
{
    spiHandler();
}

SIGNAL(TIMER0_OVF_vect)
{
    uint8_t n;
    TCNT0=TIMER0_OVERFLOW;

    timerCounter--;
    if (!timerCounter)
    {
        timerCounter=61; // a full second has elapsed
        for (n=0;n<3;n++)
        {
            if (leds[n].blinkCount>0)
            {
                leds[n].blinkCount--;
                if (leds[n].blinkCount==0) leds[n].status=LEDSTATUS_OFF;
            }
        }
    }
}



int main(void)
{
    uint8_t n;
    DDRC = 0xFF;  // LCD

    // wait a little after booting
    uint8_t i1;
    uint8_t i2;
    uint8_t i3;
    for(i1=0;i1<5;i1++) for (i2=0;i2<255;i2++) for (i3=0;i3<255;i3++); 


    initLCD();

    // Timer
    TCCR0A=0;
    TCCR0B=TIMER0_PRESCALER;
    TCNT0=TIMER0_OVERFLOW;
    TIMSK0|=(1<<TOIE0);  // start timer

    initSPI();

    sei();
    gotoXY(0,0);
    writeLCD("Booting");

    leds[0].blinkCount=255;
    leds[1].blinkCount=255;
    leds[2].blinkCount=255;
    leds[0].status = LEDSTATUS_BLINK;
    leds[1].status = LEDSTATUS_BLINK;
    leds[2].status = LEDSTATUS_BLINK;
    


    // Leds
    PORTA |=0b00000111;
    DDRA |= 0b00000111;
    while(1)
    {
        // will process an SPI command if there is one
        processSPICommand();

        blinkCount++;
        if (blinkCount==10000)
        {
            for (n=0;n<3;n++)
            {
                if (leds[n].status==LEDSTATUS_BLINK)
                {
                    PINA=(1<<n); //toggle
                }
            }
            blinkCount=0;
        }
        for (n=0;n<3;n++)
        {
            if (leds[n].status==LEDSTATUS_OFF) PORTA&= ~(1<<n);
            if (leds[n].status==LEDSTATUS_ON) PORTA|= (1<<n);
        }
    }
}
