// THIS IS FOR THE 2x16 LCD

#include "lcd2.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include "../config.h"

volatile static uint8_t pos;
volatile static uint8_t row;
volatile static uint8_t col;

void setPosition();

void delay(){
	uint8_t i,i2;
	for (i=0;i<255;i++) for (i2=0;i2<100;i2++);
}

void trigger()
{
    uint8_t i; 
	PORTC |= 0b01000000;
    for (i=0;i<255;i++);        // needs to be 1us
	PORTC &= 0b10111111;
}


void writeCommand(uint8_t cmd)
{
	PORTC = cmd>>4;
	trigger();
	PORTC = cmd & 0x0F;
	trigger();
}

void writeData(uint8_t data)
{
	PORTC = ((data>>4)|0b00100000);
	trigger();
	PORTC = ((data & 0x0F)|0b00100000);
	trigger();
}

void clearRow(uint8_t r)
{
    row=r;
    col=0;
    setPosition();
    uint8_t i;
    for (i=0;i<16;i++) writeData(' ');
    delay();
    
}


void lcdScrollLeft()
{
	writeCommand(0x18);
}

void lcdScrollRight()
{
	writeCommand(0x1E);
}



void calculatePosition(uint8_t pos){
	col = pos % 16;
	row = pos / 16;
}


void setPosition(){
	uint8_t cmd = 0x80;

	if (row==0){
		cmd |= col;
	} else{
		cmd += col+0x40;
    }


	writeCommand(cmd);
}


void initLCD()
{
	uint8_t i,i2;
	for (i=0;i<255;i++)for (i2=0;i2<255;i2++);
	
	PORTC = 0x03;
	trigger();
	PORTC = 0x03;
	trigger();
	PORTC = 0x03;
	trigger();
	PORTC = 0x02;
	trigger();
	
	writeCommand(0x28);
	delay();
	delay();
	writeCommand(0x08);
	delay();
	delay();
	writeCommand(0x0C);
	delay();
	delay();
	writeCommand(0x0f);
	delay();
	delay();
	writeCommand(0x01);
	delay();
	delay();
	writeCommand(0x06);
	delay();
	delay();

}

void clearLine()
{
    uint8_t oldCol = col;
    while (col<16){
        writeData(' ');
        col++;
    }
    col = oldCol;
    setPosition();
}

void writeLCD(char *st)
{
    char c;
	while (*st)
	{
		if (*st == '\r'){
		//} else if (*st == ' '){
		//} else if (*st == 32){
        //    clrscr();
		} else if (*st == '\n'){
			row++;
			col=0;
			setPosition();	
		} else {
            if (col>=16){
                row++;
                col=0;
                setPosition();
            }
            if (*st>=32 && *st<128)
            {
                c = *st;
            } else {
                c = ' ';
            }
           
			writeData(*st);
            col++;
		}

		st++;
	}
}

void writeNumber(uint8_t b)
{
    uint8_t num[3];

    num[0] = 48+ (b/100);
    num[1] = 48+ ((b%100)/10);
    num[2] = 48+ (b%10);

    // delete 1st leading zero
    if (num[0]==48)
    {
        num[0]=num[1];
        num[1]=num[2];
        num[2]=0;

    }
    // delete 2nd leading zero
    if (num[0]==48)
    {
        num[0]=num[1];
        num[1]=0;
    }


    uint8_t i;
    for (i=0;i<3;i++) if(num[i]!=0) writeData(num[i]);


}



void clrscr()
{
	writeCommand(0x01);
}


void gotoXY(uint8_t pcol, uint8_t prow)
{
	row=prow;
	col=pcol;
	setPosition();	

}
