#include "Logging.h"
#include <stdio.h>
#include <string>
#include <sstream>
#include "PGM.h"
#include "Insteon.h"
#include "ServiceProvider.h"
#include "WebServer.h"
#include "PhoneService.h"
#include "RESTInterface.h"
#include "EventProcessor.h"
#include "SoundService.h"
#include "SMTPService.h"
#include "bcm2835.h"
#include <sched.h>
#include "config.h"
#include "WeatherHelper.h"
#include <execinfo.h>
#include <signal.h>

void handler(int sig) {
  void *array[10];
  size_t size;

  // get void*'s for all entries on the stack
  size = backtrace(array, 10);

  // print out all the frames to stderr
  fprintf(stderr, "Error: signal %d:\n", sig);
  backtrace_symbols_fd(array, size, 2);
  exit(1);
}

//For examples on how to use GPIO, check out the bcm2835 C library
int main(int argc, char** argv) 
{ 
    bool daemon = false;
    char *scriptName = 0;
    char *soundsFolder = 0;
    for (int i=0;i<argc;i++)
    {
        std::string param = argv[i];
        if (param=="-d")
        {
            daemon = true;
        }
    }

    if (daemon)
    {
        if (fork()>0) exit(0);
    }

    Logging::log("Starting\r\n");
    signal(SIGSEGV, handler);
    bcm2835_init();

    Schedule schedule;
    WeatherHelper weather;
    ServiceProvider serviceProvider;
    RESTInterface *pRESTInterface = new RESTInterface(&serviceProvider,&schedule,&weather);
    PGM *pPGM = new PGM();
    Insteon *pInsteon = new Insteon(INSTEON_SERIAL_PORT);
    WebServer *pWebServer = new WebServer(WEBSERVER_PORT,pRESTInterface);
    PhoneService *pPhoneService = new PhoneService();
    SoundService *pSoundService = new SoundService();
    SMTPService *pSMTPService = new SMTPService();

    
    serviceProvider.addService(pPGM);
    serviceProvider.addService(pInsteon);
    serviceProvider.addService(pPhoneService);
    serviceProvider.addService(pWebServer);
    serviceProvider.addService(pSoundService);
    serviceProvider.addService(pSMTPService);

    // This needs to be created after services because it will load a script
    EventProcessor eventProcessor(pRESTInterface,&schedule,&weather,&serviceProvider);
    serviceProvider.startServices(&eventProcessor);

    Logging::log("Ready\r\n\r\n");
    while (eventProcessor.timeSlice());
    Logging::log("Exiting\r\n");
    serviceProvider.stopServices();

    bcm2835_close();

    return 0; 
}
