#ifndef JSONVALUE_H
#define JSONVALUE_H

#include "JSON.h"

namespace Dumais
{
    namespace JSON
    {
	    class Value: public JSON{
    	private:
	        std::string mValue;
    	    JSON mInvalid;

            friend class Object;
            friend class List;
            Value(std::string value);

            std::string stringify(int level);    
            virtual JSON* copy();
    	    virtual JSON* getByIndex(int i);
    	    virtual JSON* getByKey(std::string key);
    	    virtual std::string toString();
    	    virtual void setStringValue(std::string value);
	        virtual void assign(const JSON& json);
            virtual JSON& addObject(const std::string& name="");
            virtual JSON& addList(const std::string& name="");
            virtual JSON& addValue(const std::string& val,const std::string& name="");
    

    	public:
    		virtual ~Value();

    	};
    }
}
#endif

