#include "Parser.h"

#include "Object.h"
#include "List.h"
#include "Value.h"
#include <algorithm>

using namespace Dumais::JSON;

Parser::Parser(){
}

Parser::~Parser(){
}

std::string Parser::removeSpaces(std::string str)
{
    std::string ret="";

    size_t i=0;
    while (i<str.size())
    {
        char c = str[i];
        if (c=='\"')
        {
            size_t l = findClosingQuote(str.substr(i));
            if (l==std::string::npos) return "";
            while (l)
            {
                ret+=str[i];
                i++;
                l--;
            }
        } else if (c=='\t' || c==' ' || c=='\r' || c=='\n') {
            i++;
        } else {
            i++;
            ret+=c;
        }
    }

    return ret;
}


Pair Parser::getPair(std::string str)
{
    const char *buf = str.c_str();
    Pair p;
    p.size=0;
    
    std::string key = parseString(str);
    p.key = key;
    p.size+=key.size()+2;
    buf += key.size()+2;

    if (*buf!=':')
    {
        p.val.type = JSON_Invalid;
        return p;
    }
    buf++;
    p.size++;

    JSONProperty val = getValue(buf);

    p.size+=val.size;
    p.val = val;
    return p;
}


JSONProperty Parser::getValue(std::string str)
{
    const char *buf = str.c_str();
    JSONProperty val;
    val.size=0;

    if (*buf=='{'){
        size_t i = findClosingCurly(str);
        if (i!=std::string::npos){
            val.value = str.substr(0,i);
            val.size +=i;
            val.type=JSON_Object;
        } else {
            val.type = JSON_Invalid;
        }
    } else if (*buf=='['){
        size_t i = findClosingBracket(str);
        if (i!=std::string::npos){
            val.value = str.substr(0,i);
            val.size +=i;
            val.type=JSON_List;
        } else {
            val.type = JSON_Invalid;
        }
    } else if (*buf=='\"'){ 
        val.value=parseString(str);
        val.type=JSON_Value;
        val.size += val.value.size()+2;
    } else if ((*buf >= 0x30 && *buf<=0x39) || (*buf>='a' && *buf<='z') || (*buf>='A' && *buf<='Z') || *buf=='.' || *buf=='-'){
        std::string tmp = parseNakedValue(str);
        val.value+=validateNakedValue(tmp);
        val.size+=tmp.size();
        val.type=JSON_Value;
    } else {
        val.type = JSON_Invalid;
    }

    return val;

}


std::string Parser::parseString(std::string str)
{
    const char *buf=str.c_str();

    if (buf[0]!='\"') return "";

    size_t i = findClosingQuote(str);
    return str.substr(1,i-2);
}

std::string Parser::validateNakedValue(std::string ret)
{
    std::string tmp = ret;
    transform (tmp.begin (), tmp.end (), tmp.begin (), (int(*)(int)) tolower);

    if (tmp == "true" || tmp=="false")
    {
//printf("%s\r\n",ret.c_str());
        return ret;
    }

    bool bad = false;
    bool dot =false;
    for (size_t i=0;i<ret.size();i++)
    {
        if (ret[i]=='-'){
             if (i!=0) bad = true;
        } else if (ret[i]=='.')
        {
            if (dot)
            {
                bad = true;
            } else {
                dot = true;
            }
        } else if (ret[i]<0x30 || ret[i]>0x39){

            bad = true;
        }

    }
    if (bad) ret= "{illegal}";

    return ret;
    
}


std::string Parser::parseNakedValue(std::string str)
{
    const char *buf=str.c_str();

    std::string ret;
    while ((*buf >= 0x30 && *buf<=0x39) || (*buf>='a' && *buf<='z') || (*buf>='A' && *buf<='Z') || *buf=='.' || *buf=='-')
    {
        ret += *buf;
        buf++;
    }

    return ret;
}


size_t Parser::findClosingCurly(std::string str)
{
    const char *buf=str.c_str();
    const char *b2 = buf;

    if (buf[0]!='{') return std::string::npos;

    int level =1;
    buf++;
    while (*buf!=0)
    {
        if (*buf=='\"')
        {
            size_t i = findClosingQuote(buf);
            if (i==std::string::npos) return std::string::npos;
            buf+=i;
            continue;
        } else if (*buf=='{'){
            level++;
        } else if (*buf=='}'){
            level--;
        }
        buf++;
        if (!level) return (unsigned long)buf - (unsigned long)b2;
    }

    return std::string::npos;


}

size_t Parser::findClosingBracket(std::string str)
{
    const char *buf=str.c_str();
    const char *b2 = buf;

    if (buf[0]!='[') return std::string::npos;

    int level =1;
    buf++;
    while (*buf!=0)
    {
        if (*buf=='\"')
        {
            size_t i = findClosingQuote(buf);
            if (i==std::string::npos) return std::string::npos;
            buf+=i;
            continue;
        } else if (*buf=='['){
            level++;
        } else if (*buf==']'){
            level--;
        }
        buf++;
        if (!level) return (unsigned long)buf - (unsigned long)b2;
    }

    return std::string::npos;
}


size_t Parser::findClosingQuote(std::string str)
{
    const char *buf=str.c_str();
    const char *b2 = buf;
    
    if (buf[0]!='\"') return std::string::npos;

    buf++;
    while (*buf!=0)
    {
        if (*buf=='\\') // escape char, skip next one
        {
            buf+=2;
        }
        if (*buf=='\"') break;
        buf++;
    }

    return (unsigned long)buf - (unsigned long)b2 +1;

}

