#ifndef JSONOBJECT_H
#define JSONOBJECT_H

#include "JSON.h"
#include <map>
namespace Dumais
{
    namespace JSON
    {

	    class Object: public JSON{
    	private:
	        friend class Parser;
            friend class List;
            friend class JSON; 
	        std::map<std::string,JSON*> mMembers;
    	    JSON mInvalid;
	        void parseObject(std::string str);
            std::string generateKey();
            Object(std::string str);
            virtual JSON* copy();

            virtual JSON& addObject(const std::string& name="");
            virtual JSON& addList(const std::string& name="");
            virtual JSON& addValue(const std::string& val,const std::string& name="");
	        virtual JSON* getByIndex(int i);
	        virtual JSON* getByKey(std::string key);
    	    virtual std::string stringify(int level);
    	    virtual std::string toString();
    	    virtual void setStringValue(std::string value);
    	    virtual void assign(const JSON& json); 
        
            


	    public:
        	virtual ~Object();

    	};

        //static JSON* Object(std::string name);
    }
}
#endif

