#ifndef JSONLIST_H
#define JSONLIST_H

#include <vector>
#include "JSON.h"
namespace Dumais
{
    namespace JSON
    {
    	class List: public JSON{
    	private:
    	    friend class Parser;
            friend class Object;
            List(std::string json);
    	    std::vector<JSON*> mMembers;
    	    JSON mInvalid;
    	    void parseList(std::string str);
            std::string stringify(int level);
            virtual JSON& addObject(const std::string& name="");
            virtual JSON& addList(const std::string& name="");
            virtual JSON& addValue(const std::string& val,const std::string& name="");
    	    virtual JSON* getByIndex(int i);
    	    virtual JSON* getByKey(std::string key);
            virtual JSON* copy();
    	    virtual std::string toString();
    	    virtual void setStringValue(std::string value);
    	    virtual void assign(const JSON& json);
                


    	public:
    		virtual ~List();
            

    	};
    }
}
#endif

