#ifndef JSON_H
#define JSON_H

#include <string>
#include "Parser.h"
namespace Dumais
{
    namespace JSON
    {
        // WARNING: It is not possible to use this object as a return value of a function. See "assign" method 
        // for description of why we can't do this.
       	class JSON{
    	protected:
    	    virtual JSON* getByIndex(int i);
    	    virtual JSON* getByKey(std::string key);
    	    virtual std::string toString();
    	    bool mIsRoot;
    	    JSON *mRoot;
    	    Parser mParser;

    	    virtual void clean();
    	    std::string parseString(const char *buf); 
    	    virtual void setStringValue(std::string value);
    	    virtual void assign(const JSON& json);

    	public:
    	    JSON();
            JSON(const JSON& json);
    		virtual ~JSON();

    	    JSON& operator[](int i);
    	    JSON& operator[](std::string str);
    	    JSON& operator=(const std::string& val);
    	    JSON& operator=(const JSON& json);

            virtual JSON* copy();
    	    std::string str();
    	    void parse(std::string json);

	        std::string stringify(bool formatted=false);
	        virtual std::string stringify(int level=-1);
        
            virtual JSON& addObject(const std::string& name="");
            virtual JSON& addList(const std::string& name="");
            virtual JSON& addValue(const std::string& val,const std::string& name="");
            JSON& addValue(int val, const std::string& name="");
            JSON& addValue(unsigned int val, const std::string& name="");
            JSON& addValue(double val, const std::string& name="");
    	};
    }
}
#endif

