#ifndef INSTEONMODEM_H
#define INSTEONMODEM_H
#include "SerialPort.h"
#include <queue>
#include "InsteonDefs.h"
#include "IInsteonMessageHandler.h"
#include <pthread.h>
#include "IInsteonMessage.h"

class InsteonModem{
private:
    pthread_mutex_t queueLock;
    std::queue<IInsteonMessage*> mInsteonCommandQueue;
    SerialPort *mpSerialPort;
    time_t mTimeLastSend;
    IInsteonMessageHandler *mpInsteonMessageHandler;
    bool mWaitingForResponse;
    

    void processAllLinkRecordResponse(unsigned char* buf);
    void setIMConfiguration(unsigned char cmd);
public:
	InsteonModem(char *serialPort, IInsteonMessageHandler *p);
	~InsteonModem();

    bool process(bool readyToSend);

    void writeCommand(InsteonID destination, unsigned char cmd1, unsigned char cmd2);
    void writeExtendedCommand(InsteonID destination, unsigned char cmd1, unsigned char cmd2, unsigned char* data);
    void waitForUnsolicitedMessage();
    void processStandardMessage(unsigned char *buf);

    bool waitForReply(IInsteonMessage *cmd);
    int  getByte();
    void processEcho(unsigned char* buf);
    void processUnsolicitedEvent(unsigned char *buf);
    bool sendCommand(IInsteonMessage* cmd);

    void getFirstAllLinkRecord();
    void getNextAllLinkRecord();

};

#endif

