#include "../Logging.h"
#include "InsteonDevice.h"

InsteonDevice::InsteonDevice(std::string name, InsteonID id, InsteonModem* p)
{
    mName = name;
    mID = id;
    mInitialized = false;
    mpInsteonModem = p;
    mTransmissionStatus = Idle;
    mLastMessageTimeStamp = true;
}


InsteonDevice::~InsteonDevice(){
}

void InsteonDevice::onTimer(time_t t)
{
}

bool InsteonDevice::isIdle()
{
    time_t t;
    time(&t);

    if ((t-mLastMessageTimeStamp)>=2 && (mTransmissionStatus!=Idle))
    {
        Logging::log("Message timeout for device %x (last=%i, now=%i)",mID,mLastMessageTimeStamp,t);
        // it has been 2 seconds since we last sent a message, consider it timed out.
        mTransmissionStatus=Idle;
        mLastMessageTimeStamp=0;
    }

    return (mTransmissionStatus==Idle);
}

std::string InsteonDevice::getName()
{
    return mName;
}

InsteonID InsteonDevice::getID()
{
    return mID;
}

InsteonDirectMessage InsteonDevice::getLastDirectMessageSent()
{
    return mLastDirectMessageSent;
}

void InsteonDevice::setLastDirectMessageSent(InsteonDirectMessage cmd)
{
    time(&mLastMessageTimeStamp);
    mLastDirectMessageSent = cmd;
    mTransmissionStatus = WaitingAckOfDirectMessage;
}

bool InsteonDevice::isInitialized()
{
    return mInitialized;
}

void InsteonDevice::setInitialized()
{
    mInitialized = true;
}

void InsteonDevice::setDeviceParameter(unsigned char param)
{
    mDeviceParameter = param;
}

void InsteonDevice::writeCommand(InsteonID destination, unsigned char cmd1, unsigned char cmd2)
{
    if (!mpInsteonModem) return;

    mpInsteonModem->writeCommand(destination,cmd1,cmd2);
}

void InsteonDevice::writeExtendedCommand(InsteonID destination, unsigned char cmd1, unsigned char cmd2, unsigned char* data)
{
    if (!mpInsteonModem) return;

    mpInsteonModem->writeExtendedCommand(destination,cmd1,cmd2,data);
}

void InsteonDevice::onInsteonMessage(Dumais::JSON::JSON& json, unsigned char* buf)
{
    unsigned char flags = buf[8];
    unsigned char status = (flags & 0b11100000)>>5;

    if (status==0b001 && this->mLastDirectMessageSent.cmd1==0)
    {
        // we got an ACK of a direct message but we did not send a message.
        // It is probably a retransmit. Ignore it.
        Logging::log("Ignoring duplicate ACK of direct message");
        return;
    }

    this->processEvent(json, buf);

    if (status == 0b001)
    {
        // This is an ACK of a direct message.
        this->mTransmissionStatus = Idle;
        this->mLastDirectMessageSent.cmd1=0;
    }
    else if (status == 0b101)
    {
        // This is an NAK of a direct message.
        Logging::log("ERROR: NAK of a direct message");
        this->mTransmissionStatus = Idle;
    }

}
