#include "Logging.h"
#include "WebServer.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <string.h>
#include <stdio.h>
#include <netinet/tcp.h>
#include "HTTPParser.h"
#include <list>
#include <sstream>
#include "ServiceProvider.h"
#include "PGM.h"
#include "json/JSON.h"
#include <stdlib.h>
#define BUF_SIZE 1024

WebServer::WebServer(int port,RESTInterface *pRESTInterface)
{
    mpRESTInterface = pRESTInterface;
    mPort = port;
}

WebServer::~WebServer(){
}


// This server accepts one connection at a time only. So sockets are blocking
void WebServer::run()
{
    //TODO: should implement timeout on socket to prenvent locking the server.

    mServerSocket = socket(AF_INET,SOCK_STREAM,0);
    sockaddr_in sockadd;
    sockadd.sin_family=AF_INET;
    sockadd.sin_addr.s_addr=INADDR_ANY;
    sockadd.sin_port=htons(mPort);

    if (bind(mServerSocket,(struct sockaddr *)&sockadd,sizeof(sockadd))<0){
        Logging::log("Could not bind web server socket\r\n");
        return;    
    } 
    
    listen(mServerSocket,1);

    char *buf = new char[BUF_SIZE];
    while (!stopping())
    {
        int clientSocket = accept(mServerSocket,0,0);
        int size=0;
        if (size=read(clientSocket,buf,BUF_SIZE)) // only one request and then we disconnect it
        {
            char* b = new char[1024];
            size_t num;
            for (num=0;num<1024;num++)
            {   
                if (buf[num]=='\n' || buf[num]=='\r') break;
                b[num] = buf[num];
            }
            if (num<1024)
            {
                b[num] = 0;
                Dumais::JSON::JSON json;
                mpRESTInterface->processQuery(json,buf);
                std::string st = json.stringify(false);
    //            Logging::log("Webserver response: %s",st.c_str());
                sendJSONResponse(st,clientSocket);
            }
            delete b;
    
        }
        close(clientSocket);
    }
    delete buf;
    close(mServerSocket);

}

void WebServer::sendJSONResponse(std::string json, int s)
{
    std::stringstream ss;
    ss <<"HTTP/1.1 200 OK\r\nContent-Length: " << json.size() << "\r\n";
    ss <<"Content-Type: application/json; charset=UTF-8\r\n";
    ss << "\r\n" << json;

    write(s,ss.str().c_str(),ss.str().size());

}

