#ifndef SOUNDSERVICE_H
#define SOUNDSERVICE_H
#include "Service.h"
#include <queue>
#include <string>
#include "SoundDevice.h"

/*
 Sounnd names provided must be names only. This object will append ".wav" to it and will prefix it with "sounds/"
*/

class SoundService: public Service{
private:
    SoundDevice *mpSoundDevice;
    pthread_mutex_t mPlayListLock;
    std::queue<std::string> mPlayList;
    void play(std::string filename);

public:
	SoundService();
	~SoundService();

    void play_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);

    void abortPlayList();
    

    virtual void run();
    virtual std::string getName(){return "audio";}
};

#endif

