#include "Logging.h"
#include "SoundService.h"
#include "SoundFile.h"
#include "config.h"
#include <stdio.h>
#include "SoundListParser.h"

SoundService::SoundService()
{
    mpSoundDevice = new SoundDevice(SOUND_DEVICE);
    pthread_mutex_init(&mPlayListLock,0);
    this->addCallBack("play",new ServiceCallBack<SoundService>(this,&SoundService::play_callback));
}

SoundService::~SoundService()
{
    pthread_mutex_destroy(&mPlayListLock);
}


void SoundService::play_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params)
{
    SoundListParser slp(params["sound"].str());
    std::vector<std::string> list = slp.getSoundList();
    for (std::vector<std::string>::iterator it = list.begin();it!=list.end();it++)
    {
        play(*it);
    }
}

void SoundService::run()
{
    SoundFile *pCurrentSound = 0;
    unsigned int num_frames = mpSoundDevice->getBufferSize();
    unsigned int numBytes = num_frames*mpSoundDevice->getFrameSize();
    char *buf = new char[numBytes];
    while (!stopping())
    {
        if (pCurrentSound==0)
        {
            std::string fname;
            pthread_mutex_lock(&mPlayListLock);
            if (mPlayList.size()>0)
            {
                fname = mPlayList.front();
                mPlayList.pop();
            }
            pthread_mutex_unlock(&mPlayListLock);
            if (fname!="")
            {
                Logging::log("Playing file [%s]\r\n",fname.c_str());
                pCurrentSound = new SoundFile(false);
                if (!pCurrentSound->open(fname,CD))
                {
                    delete pCurrentSound;
                    pCurrentSound = 0;
                }
            } else {
                //TODO: could use a wait condition instead of sleeping
                usleep(250000);
            }
        }

        if (pCurrentSound!=0)
        {
            int n = pCurrentSound->getSample(numBytes,buf); 
            if (n<numBytes)
            {
                for (int i=n;i<numBytes;i++)
                {
                    buf[i]=0;
                }
                delete pCurrentSound;
                pCurrentSound = 0;
            }
            mpSoundDevice->playChunk(buf);
        }
    }

    if (pCurrentSound!=0) delete pCurrentSound;

}

void SoundService::play(std::string filename)
{
    filename = SOUNDS_FOLDER+filename+"-s16.wav";
    pthread_mutex_lock(&mPlayListLock);
    mPlayList.push(filename);
    pthread_mutex_unlock(&mPlayListLock);
}
void SoundService::abortPlayList()
{
    pthread_mutex_lock(&mPlayListLock);
    mPlayList=std::queue<std::string>();
    pthread_mutex_unlock(&mPlayListLock);
}

