#include "Logging.h"
#include "config.h"
#include "SoundDevice.h"


//////////////////////////////////////////
// code sample taken from alsa-project.org
//////////////////////////////////////////
int xrun_recovery(snd_pcm_t *handle, int err){

        if (err == -EPIPE) {
                err = snd_pcm_prepare(handle);
                return 0;
        } else if (err == -ESTRPIPE) {
                while ((err = snd_pcm_resume(handle)) == -EAGAIN) sleep(1);
                if (err < 0) {
                        err = snd_pcm_prepare(handle);
                }
                return 0;
        }
        return err;
}

SoundDevice::SoundDevice(const char *device)
{
    snd_pcm_hw_params_t *params;
    int dir;
    int err;
    snd_pcm_format_t format = SND_PCM_FORMAT_S16_LE;

    snd_config_t *conf;
    snd_input_t *in;
    snd_config_top(&conf);
    snd_input_stdio_open(&in,ALSACONF,"r");
    snd_config_load(conf,in);
    snd_input_close(in);
    err=snd_pcm_open_lconf(&mpDeviceHandle, device,SND_PCM_STREAM_PLAYBACK,SND_PCM_NONBLOCK,conf);
    if (err<0)
    {
        Logging::log("Playback open error: %s\n", snd_strerror(err));
        return;
    }
    
    snd_pcm_hw_params_alloca(&params);
    // Create a 8khz 8bit 1channel MuLaw sound device
    err=snd_pcm_hw_params_any(mpDeviceHandle, params);
    if (err<0) Logging::log("snd_pcm_hw_params_any [%i]\r\n",err);
    err=snd_pcm_hw_params_set_access(mpDeviceHandle, params,SND_PCM_ACCESS_RW_INTERLEAVED);
    if (err<0) Logging::log("snd_pcm_hw_params_set_access [%i]\r\n",err);
    err=snd_pcm_hw_params_set_format(mpDeviceHandle, params,format);
    if (err<0) Logging::log("snd_pcm_hw_params_set_format [%i]\r\n",err);
    unsigned int rate=44100;
    err=snd_pcm_hw_params_set_rate_near(mpDeviceHandle, params,&rate,&dir);
    if (err<0) Logging::log("snd_pcm_hw_params_set_rate_near [%i]\r\n",err);
    err=snd_pcm_hw_params_set_channels(mpDeviceHandle,params,  2);
    if (err<0) Logging::log("snd_pcm_hw_params_set_channels [%i]\r\n",err);

    err=snd_pcm_hw_params_set_period_size(mpDeviceHandle, params,512,0);
    if (err<0) Logging::log("snd_pcm_hw_params_set_period_size [%i]\r\n",err);
//    err=snd_pcm_hw_params_set_periods(mpDeviceHandle, params,2,0);
  //  if (err<0) Logging::log("snd_pcm_hw_params_set_periods [%i]\r\n",err);
    err=snd_pcm_hw_params_set_buffer_size(mpDeviceHandle, params,2048);
    if (err<0) Logging::log("snd_pcm_hw_params_set_buffer_size [%i]\r\n",err);

    err=snd_pcm_hw_params(mpDeviceHandle,params);
    if (err<0) Logging::log("snd_pcm_hw_params [%i]\r\n",err);

    snd_pcm_hw_params_get_buffer_size(params,&mBufferSize);

    unsigned int tmp;
    snd_pcm_hw_params_get_channels(params,&tmp);
    switch (format)
    {
        case SND_PCM_FORMAT_S16_LE:
            mFrameSize = tmp*2;
            break;
        default:
            mFrameSize = tmp*1;
    }
    err=snd_pcm_prepare(mpDeviceHandle);
    if (err<0) Logging::log("snd_pcm_prepare [%i]\r\n",err);
}

SoundDevice::~SoundDevice()
{
    snd_pcm_drop(mpDeviceHandle);
}

int SoundDevice::getFrameSize()
{
    return mFrameSize;
}

int SoundDevice::getBufferSize()
{
    return mBufferSize;
}

void SoundDevice::playChunk(char *buf)
{
    int l;
        int num_frames = mBufferSize;
        while (num_frames > 0) {
            l = snd_pcm_writei(mpDeviceHandle, buf, num_frames);
            if ((l == -EPIPE)||(l == -ESTRPIPE)) {
                if (xrun_recovery(mpDeviceHandle, l) < 0)
                {
                    Logging::log("xrun_recovery failed\r\n");
                    exit(-1);
                }
                num_frames=0;
            } else if (l != -EAGAIN){
                buf += l * mFrameSize;
                num_frames -= l;
            }
        }

}
