#include "Logging.h"
#include "SilenceSound.h"
#include <sstream>

SilenceSound::SilenceSound(int duration)
{
    this->mDuration = duration;
    this->mIndex = 0;
}

SilenceSound::~SilenceSound(){
}

int SilenceSound::getSample(int size, char* buf)
{
    int i=0;
    unsigned int maxSize = 8000*this->mDuration;
    while (i<size && this->mIndex < maxSize)
    {
        buf[i]=0;
        this->mIndex++;
        i++;
    }

    return i;
}

std::string SilenceSound::toString()
{
    std::stringstream st;
    st<< this->mDuration << " seconds silence";
    return st.str();
}
