#include "Logging.h"
#include "ServiceProvider.h"

#include "Insteon.h"
#include "PGM.h"
#include "WebServer.h"
#include "PhoneService.h"
#include "SoundService.h"
#include "SMTPService.h"
#include "EventProcessor.h"

ServiceProvider::ServiceProvider()
{
}

ServiceProvider::~ServiceProvider(){
}

void ServiceProvider::addService(Service *p)
{
    mServiceMap[p->getName()]=p;
}

Service* ServiceProvider::getService(const std::string& name)
{
    if (mServiceMap.find(name)==mServiceMap.end()) return 0;

    return mServiceMap[name];
    
}

void ServiceProvider::startServices(EventProcessor *p)
{
    for (ServiceMap::iterator it = mServiceMap.begin();it!=mServiceMap.end();it++)
    {
        Service *pService = it->second;
        Logging::log("Starting %s service\r\n",pService->getName().c_str());
        pService->startService(p);
    }
}

void ServiceProvider::stopServices()
{
    for (ServiceMap::iterator it = mServiceMap.begin();it!=mServiceMap.end();it++)
    {
        it->second->waitCompletion();
    }
}

