#ifndef SERVICECALLBACK_H
#define SERVICECALLBACK_H

#include "json/JSON.h"


class CallBack
{
public: 
    virtual void call(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params)=0;
};



template <class T>
class ServiceCallBack: public CallBack{
private:
    void (T::*mpCallback)(Dumais::JSON::JSON&,Dumais::JSON::JSON&);
    T *mpObject;
public:
	ServiceCallBack(T *obj, void (T::*pCB)(Dumais::JSON::JSON&,Dumais::JSON::JSON&))
    {
        mpObject = obj;
        mpCallback = pCB;
    }

	~ServiceCallBack(){};

    void call(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params)
    {

        (mpObject->*mpCallback)(json,params);
    }
};

#endif

