#ifndef SERVICE_H
#define SERVICE_H
#include <pthread.h>
#include "EventProcessor.h"
#include "ServiceCallBack.h"

class Service{
private:
    std::map<std::string, CallBack*> mCallbackList;
    pthread_t   mThreadHandle;
    bool        mStopping;
    bool        mSuspended;
    bool        mNeedSuspend;

protected:
    bool stopping();
    bool isSuspended();
    void addCallBack(std::string name, CallBack* p);

    EventProcessor *mpEventProcessor;
public:
	Service();
	~Service();

    void suspend();
    void resume();

    void startService(EventProcessor *p);
    void waitCompletion();
    virtual void run()=0;
    virtual std::string getName()=0;

    bool runCommand(Dumais::JSON::JSON& retJSON, std::string cmd, Dumais::JSON::JSON& params);

};

#endif

