#include "Logging.h"
#include "Service.h"

#include "ServiceProvider.h"

void *ThreadStarter(void *p)
{
    Service* pService = (Service*)p;
    pService->run();
}

Service::Service(){
    mNeedSuspend = false;
    mSuspended = true;
}

Service::~Service()
{
    //TODO: delete all callbacks
}

void Service::startService(EventProcessor *p)
{
    mpEventProcessor = p;
    mStopping = false;
    mSuspended = false;
    pthread_create(&mThreadHandle, 0, ThreadStarter, this);

}

void Service::suspend()
{
    mNeedSuspend = true;
    while (!mSuspended);  // wait for the thread to be suspended
}

void Service::resume()
{
    mNeedSuspend = false;
}


void Service::waitCompletion()
{
    pthread_join(mThreadHandle,0);
}

bool Service::isSuspended()
{
    return mSuspended;
}

bool Service::stopping()
{
    // Every thread calls this function in their while loop. So if we need to suspend, keep waiting in here
    while (mNeedSuspend)
    {
        mSuspended = true;
        usleep(200000);
    }
    mSuspended = false;

    return mStopping;
}

bool Service::runCommand(Dumais::JSON::JSON& retJSON, std::string cmd, Dumais::JSON::JSON& params)
{
    if (mCallbackList.find(cmd)==mCallbackList.end()) return false;

    mCallbackList[cmd]->call(retJSON,params);
    return true;
}

void Service::addCallBack(std::string name, CallBack* p)
{
    mCallbackList[name] = p;
}
