#ifndef WAKEUPRTPSESSION_H
#define WAKEUPRTPSESSION_H

#include <ortp/ortp.h>
#include <string>
#include <queue>
#include "ISound.h"
#include <pthread.h>
#include "IRTPSessionObserver.h"
#include <list>

class RTPSession{
private:
    RtpSession *mSession;
    std::string mPeerIP;
    unsigned int mPeerPort;
    std::string mLocalIP;
    unsigned int mLocalPort;
    bool mAbort;
    std::queue<ISound*> mSoundQueue;
    pthread_mutex_t mQueueLock;
    pthread_t   mThreadHandle;
    std::list<IRTPSessionObserver*> mObservers;

    ISound* mMusic;
    void notifyQueueEmpty();
    bool mInterruptCurrentSound;

public:
	RTPSession();
	~RTPSession();

    void run();
    void start();
    void stop();
    void setMusic(const char *filename);
    void play(const char *filename);
    void playNumber(int number);
    void silence(int seconds);
    void addObserver(IRTPSessionObserver* obs);

    void setPeerAddress(std::string ip, unsigned int peerPort);
    void setLocalAddress(std::string ip, unsigned int port);    
    unsigned int getLocalPort();
    std::string getLocalIP();
    
    int getSoundQueueSize();
    void clearQueue();

};

#endif

