#ifndef RESTINTERFACE_H
#define RESTINTERFACE_H

#include <string>
#include "json/JSON.h"
#include "ServiceProvider.h"
#include "PanelController.h"
#include "Schedule.h"
#include "WeatherHelper.h"
#include <pthread.h>

class RESTInterface{
private:
    pthread_mutex_t mInvocationLock;
    ServiceProvider*    mpServiceProvider;
    PanelController mPanelController;
    Schedule* mpSchedule;
    WeatherHelper *mpWeatherHelper;
public:
	RESTInterface(ServiceProvider *pServiceProvider,Schedule* pSchedule,WeatherHelper *pWeather);
	~RESTInterface();

    void processQuery(Dumais::JSON::JSON& json, const char* query);

};

#endif

