#include "Logging.h"
#include "RESTInterface.h"
#include "HTTPParser.h"
#include <stdlib.h>
#include <string>
#include <sstream>
#include <iomanip>
#include <list>
#include "PGM.h"
#include "Insteon.h"
#include "SoundListParser.h"
#include "SoundService.h"
#include "PhoneService.h"
#include "AlarmState.h"
#include <functional>

using namespace Dumais::JSON;
using namespace std;

RESTInterface::RESTInterface(ServiceProvider *pServiceProvider,Schedule* pSchedule,WeatherHelper *pWeather)
{
    pthread_mutex_init(&mInvocationLock,0);
    mpWeatherHelper = pWeather;
    mpSchedule = pSchedule;
    mpServiceProvider = pServiceProvider;

    mPanelController.resetLCD();
    mPanelController.writeLCD(0,"      DHAS");
    mPanelController.writeLCD(1," All Systems Go");
    for (int i=0;i<3;i++) mPanelController.setLED(i,Off,0);

}

RESTInterface::~RESTInterface()
{
    pthread_mutex_destroy(&mInvocationLock);
}

void RESTInterface::processQuery(Dumais::JSON::JSON& json, const char* query)
{
    HTTPParser parser(query);
    std::string req = parser.getRequest();
    bool processed = false;
    size_t pos = req.find('/',1);
    if (pos==std::string::npos) return;
    std::string reqLevel1 = req.substr(1,pos-1);

    Service *pService = this->mpServiceProvider->getService(reqLevel1);
    if (pService)
    {
        std::map<std::string,std::string> params = parser.getParamList();
        std::string reqLevel2 = req.substr(pos+1,std::string::npos);

        Dumais::JSON::JSON jParams;
        for (std::map<std::string,std::string>::iterator it= params.begin();it!=params.end();it++)
        {
            jParams.addValue(it->second,it->first);
        }

        /*
        * We want to lock here because the Webserver thread and the EventProcessor thread make
        * calls to this function. We want to make sure that only one service call at a time is made.
        */
        pthread_mutex_lock(&mInvocationLock);
        processed = pService->runCommand(json,reqLevel2,jParams);
        pthread_mutex_unlock(&mInvocationLock);
    }
        
    


    if (!processed)
    {
        //TODO REFACTORING: these commands do not belong to a service. We should make this cleaner
        // could use a "Utilities" class.
        // /alarm should be handled by SMTP (and renamed)
        // Panel controller should be a ervice
        // Weather should be in a utilisty class
        // Schedule should be handled by the event Processor
            if (req=="/alarm/getlogs")
            {
                AlarmState as;
                //json.addList("alarmlogs");
                std::list<std::string> list = as.getLogs();
                std::string tmp="{\"alarmlogs\":[";
                int i=0;
                for (std::list<std::string>::iterator it = list.begin();it!=list.end();it++)
                {
                    i++;
                    tmp+=*it;
                    if (i!=list.size()) tmp+=",";
                }
                tmp+="]}";
                json.parse(tmp);
            }
            else if (req=="/panel/led")
            {
                LEDAction action;
                unsigned char tmp = 0;
                if(parser.getParam("action")=="on") action = On;
                else if(parser.getParam("action")=="off") action = Off;
                else if(parser.getParam("action")=="blink") action = Blink;
                if (parser.getParam("time")!="") tmp = atoi(parser.getParam("time").c_str());
                mPanelController.setLED(atoi(parser.getParam("id").c_str()),action,tmp);
            }
            else if (req=="/panel/lcd")
            {
                int row = 0;
                if (parser.getParam("row")!="") row = atoi(parser.getParam("row").c_str());
                mPanelController.writeLCD(row,parser.getParam("str"));
            }
            else if (req=="/panel/lcd/reset")
            {
                mPanelController.resetLCD();
            }
            else if (req=="/weather/temperature")
            {
                int temp = mpWeatherHelper->getCurrentTemperature();
                json.addValue(temp,"temperature");
            }
            else if (req=="/events/show")
            {
                json.addList("events");
                std::vector<ScheduledEvent> list = mpSchedule->getAllEvents();
                for (std::vector<ScheduledEvent>::iterator it= list.begin();it!=list.end();it++)
                {
                    ScheduledEvent event = *it;
                    Dumais::JSON::JSON obj = json["events"].addObject("scheduledevent");
                    obj.addValue(event.getID(),"id");
                    obj.addValue(event.getName(),"name");
                    obj.addValue(event.getParam(),"param");
                    obj.addValue(event.getMinute(),"minute");
                    obj.addValue(event.getHour(),"hour");
                    obj.addValue((unsigned int)event.getTimeout(),"timeout");
                    
                }
            }
            else if (req=="/events/add")
            {
                ScheduledEvent *pEvent = new ScheduledEvent(parser.getParam("name"),parser.getParam("p"),atoi(parser.getParam("min").c_str()),atoi(parser.getParam("hour").c_str()));
                mpSchedule->addEvent(pEvent);
                if (parser.getParam("recurrent")=="true")
                {
                    json.addValue("We do not support recurrent events yet because we would need to flush DB everytime","ERROR");
                }
            }
            else if (req=="/events/remove")
            {
                int id = atoi(parser.getParam("id").c_str());
                mpSchedule->removeEvent(id);                
            }
            else if (req=="/events/gettime")
            {
                time_t t;
                time(&t);
                time_t sunrise = mpWeatherHelper->getSunRise();
                time_t sunset = mpWeatherHelper->getSunSet();
                bool night = false;
                if (t>=sunset || t<sunrise) night = true;

                json.addValue((unsigned int)t,"timestamp");
                json.addValue(night?"true":"false","night");
            }
        }
}
