#ifndef PHONESERVICE_H
#define PHONESERVICE_H

#include "Service.h"
#include "SIPEngine.h"

typedef std::map<Subscription*,std::string> BLFList;

class PhoneService: public Service, public TelephonyObserver, public RTPObserver
{
private:
    SIPEngine mSIPEngine;
    std::map<std::string,Call*> mCallsList;
    BLFList mBLFList;
    int mMWI;

    Call* call(std::string destination,std::string playString, bool hangupAfterSounds=true);
    void playOnCall(std::string id, std::string playstring, bool hangupAfterSounds=false);
    void subscribeBLF(std::string device);
    void subscribeMWI(std::string device);
    void getCallsList(Dumais::JSON::JSON &json);
    void getBLFList(Dumais::JSON::JSON &json);
    void releaseCall(std::string id);
    void registerUserAgent(std::string user, std::string pin, std::string proxy);

public:
	PhoneService();
	~PhoneService();

    virtual void run();
    virtual std::string getName(){return "phone";}

    void call_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void register_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void blf_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void showcalls_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void showblf_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void release_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void play_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);


    virtual void onRTPSessionSoundQueueEmpty(Call *call);
    int getMWI();

    virtual void onMWI(int num);
    virtual void onConnectedUas(Call *pCall);
    virtual void onAnswer(Call *pCall);
    virtual void onDigit(Call *pCall, std::string digit);
    virtual bool onNewCallUas(Call *pCall);
    virtual bool onNewCallUac(Call *pCall);
    virtual void onCallTerminated(Call *pCall);
    virtual void onPresence(Subscription *sub);
    virtual void onNewDevicePresence(Subscription *sub);
};

#endif

