#include "Logging.h"
#include "PanelController.h"
#include "bcm2835.h"
#include <stdio.h>

PanelController::PanelController()
{
    bcm2835_spi_begin();
    bcm2835_spi_setBitOrder(BCM2835_SPI_BIT_ORDER_MSBFIRST);
    bcm2835_spi_setDataMode(BCM2835_SPI_MODE0); 
    bcm2835_spi_setClockDivider(BCM2835_SPI_CLOCK_DIVIDER_2048); //1.953125MHz
    bcm2835_spi_chipSelect(BCM2835_SPI_CS0);
    bcm2835_spi_setChipSelectPolarity(BCM2835_SPI_CS0, LOW);
}

PanelController::~PanelController()
{
    bcm2835_spi_end();
}

void PanelController::writeLCD(int col, std::string message)
{
    waitSPIReady();

    sendByte(2);  // WriteLCD command
    sendByte((unsigned char)col);

    int i=0;
    const char *buf=message.c_str();
    while (i<16 && buf[i]!=0)
    {
        sendByte((unsigned char)buf[i]);
        i++;
    }
    // now send zeros if string was less than 16bytes
    for (int n=i;n<16;n++)
    {
        sendByte(0x20);
    }
}

void PanelController::setLED(int led, LEDAction action,unsigned char count)
{
    waitSPIReady();
    
    sendByte(1); // set LED command
    sendByte((unsigned char)led);
    if (action==Off)
    {
        sendByte(2);
        sendByte(0);
    }
    else if (action==On)
    {
        sendByte(2);
        sendByte(1);
    }
    else if (action==Blink)
    {
        sendByte(1);
        sendByte(count);
    }
}

void PanelController::resetLCD()
{
    waitSPIReady();
    sendByte(254);
}

void PanelController::waitSPIReady()
{
    unsigned char b = sendByte(255);
    if (b==1)
    {
//        Logging::log("spi is in a bad state\r\n");
        while (b==1)
        {
            // if state == 1, it means something wrong happend and SPI is out of sync. Send 0 until it is done receiving commands and ready to accept
            b = sendByte(0);
        }

  //      Logging::log("spi is back in sync\r\n");
    }
    while (sendByte(255)!=0); // wait until sending a dummy byte returns SPISTATE_IDLE
}

unsigned char PanelController::sendByte(unsigned char b)
{

    unsigned char c = bcm2835_spi_transfer(b);
//Logging::log("Sending %i and got %i\r\n",b,c);
    return c;
}
