#include "Logging.h"
#include "PGM.h"
#include "bcm2835.h"
#include <stdio.h>
#include <sstream>
#include <string.h>
#include "config.h"
#include <stdlib.h>

#define PGM1 RPI_GPIO_P1_12
#define PGM2 RPI_GPIO_P1_16
#define PGM3 RPI_GPIO_P1_18
#define PGM4 RPI_GPIO_P1_22

PGM::PGM(){

    //bcm2835_gpio_fsel(RPI_GPIO_P1_07, BCM2835_GPIO_FSEL_OUTP);
    //bcm2835_gpio_write(RPI_GPIO_P1_07,HIGH);

    bcm2835_gpio_fsel(PGM1, BCM2835_GPIO_FSEL_INPT);
    bcm2835_gpio_set_pud(PGM1, BCM2835_GPIO_PUD_UP);

    bcm2835_gpio_fsel(PGM2, BCM2835_GPIO_FSEL_INPT);
    bcm2835_gpio_set_pud(PGM2, BCM2835_GPIO_PUD_UP);
    bcm2835_gpio_fsel(PGM3, BCM2835_GPIO_FSEL_INPT);
    bcm2835_gpio_set_pud(PGM3, BCM2835_GPIO_PUD_UP);
    bcm2835_gpio_fsel(PGM4, BCM2835_GPIO_FSEL_INPT);
    bcm2835_gpio_set_pud(PGM4, BCM2835_GPIO_PUD_UP);

    mPgmStatus[0]=-1;
    mPgmStatus[1]=-1;
    mPgmStatus[2]=-1;
    mPgmStatus[3]=-1;

    pthread_mutex_init(&mLogLock,0);

    this->addCallBack("getlogs",new ServiceCallBack<PGM>(this,&PGM::getlogs_callback));
    this->addCallBack("querypgm",new ServiceCallBack<PGM>(this,&PGM::querypgm_callback));

}

PGM::~PGM(){
    pthread_mutex_destroy(&mLogLock);
}


void PGM::getlogs_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params)
{
    std::string tmp="{\"pgmlogs\":[";
    std::list<std::string> list = getLogs();
    int i=0;
    for (std::list<std::string>::iterator it = list.begin();it!=list.end();it++)
    {
       i++;
       tmp+=*it;
       if (i!=list.size()) tmp+=",";
    }
    tmp+="]}";
    json.parse(tmp);

}

void PGM::querypgm_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params)
{
    std::string pgmNumber = params["pgm"].str();
    int status = -1;
    if (pgmNumber != "")
    {
        status =  queryPGMStatus(atoi(pgmNumber.c_str()));
    }

    std::string val = "bad";
    if (status==0) val="false";
    if (status==1) val="true";
    json.addValue(val,"pgmstatus");
}


int PGM::getPGMStatus(int pgm)
{
    if (pgm==1){
        pgm = PGM1;
    } else if (pgm==2)
    {
        pgm = PGM2;
    } else if (pgm==3)
    {
        pgm = PGM3;
    } else if (pgm==4)
    {
        pgm = PGM4;
    }   

    return bcm2835_gpio_lev(pgm);
}

void PGM::run()
{
    while (!stopping())
    {
        time_t t;
        time(&t);
        std::string st = ctime(&t);
        st.resize(st.size()-1); // remove carriage return

        int tmp0 = getPGMStatus(1);
        int tmp1 = getPGMStatus(2);
        int tmp2 = getPGMStatus(3);
        int tmp3 = getPGMStatus(4);
        if (tmp0 != mPgmStatus[0] && mPgmStatus[0]!=-1)
        {
            Dumais::JSON::JSON json;
            json.addValue("pgm","event");
            json.addValue(st,"time");
            json.addValue(1,"pgm");
            json.addValue(tmp0,"status");
            mpEventProcessor->processEvent(json);
            log(json.stringify(false));
        
        }
        if (tmp1 != mPgmStatus[1] && mPgmStatus[1]!=-1)
        {
            Dumais::JSON::JSON json;
            json.addValue("pgm","event");
            json.addValue(2,"pgm");
            json.addValue(tmp1,"status");
            json.addValue(st,"time");
            mpEventProcessor->processEvent(json);
            log(json.stringify(false));
        }
        if (tmp2 != mPgmStatus[2] && mPgmStatus[2]!=-1)
        {
            Dumais::JSON::JSON json;
            json.addValue("pgm","event");
            json.addValue(3,"pgm");
            json.addValue(tmp2,"status");
            json.addValue(st,"time");
            mpEventProcessor->processEvent(json);
            log(json.stringify(false));
        }
        if (tmp3 != mPgmStatus[3] && mPgmStatus[3]!=-1)
        {
            Dumais::JSON::JSON json;
            json.addValue("pgm","event");
            json.addValue(4,"pgm");
            json.addValue(tmp3,"status");
            json.addValue(st,"time");
            mpEventProcessor->processEvent(json);
            log(json.stringify(false));
        }


        mPgmStatus[0] = tmp0;
        mPgmStatus[1] = tmp1;
        mPgmStatus[2] = tmp2;
        mPgmStatus[3] = tmp3;

        usleep(250000);
    }
}

int PGM::queryPGMStatus(int pgm)
{
    if (pgm>=0 && pgm<10)
    {
        return mPgmStatus[pgm];
    }
    return -1;
}

void PGM::log(std::string log)
{
    log+="\r\n";
    pthread_mutex_lock(&mLogLock);
    FILE *f=fopen(PGMLOGS,"a+");
    fwrite(log.c_str(),log.size(),1,f);
    fclose(f);
    pthread_mutex_unlock(&mLogLock);
    Logging::log("%s",log.c_str());
}

std::list<std::string> PGM::getLogs()
{
    std::list<std::string> list;

    char st[1024];
    pthread_mutex_lock(&mLogLock);
    FILE *f=fopen(PGMLOGS,"r");
    if (!f) return list;
    while (fgets(st,1024,f))
    {
        st[strlen(st)-1]=0;
        list.push_back(st);
    }
    fclose(f);
    pthread_mutex_unlock(&mLogLock);

    return list;

}
