#ifndef INSTEON_H
#define INSTEON_H
#include "Service.h"
#include <map>
#include <list>
#include <queue>
#include <string>
#include "insteon/InsteonDevice.h"
#include "json/JSON.h"
#include "insteon/IInsteonMessageHandler.h"
#include "insteon/InsteonModem.h"
//#include "ServiceCallBack.h"

class Insteon: public Service, public IInsteonMessageHandler
{
private:
  //  std::map<std::string,ServiceCallBack<Insteon>*> mCallbacks;
    std::map<InsteonID,InsteonDevice*> mModules;
    int currentState;
    InsteonID mControllerID;
    InsteonModem *mpInsteonModem;

    void setController(InsteonID id);
    void clearModuleList();
    void listModules(Dumais::JSON::JSON& json);
    InsteonID getControllerID();
    void addModuleDefinition(InsteonID id, std::string name);
    void addEZFlora(InsteonID id, std::string name);
    void lightOn(InsteonID id, unsigned char level=0xFF);
    void lightOff(InsteonID id);
    void rampOn(InsteonID id, unsigned char level=0x0F, unsigned char rate=0x0F);
    void rampOff(InsteonID id, unsigned char rate=0x0F);
    void lightToggle(InsteonID id, bool  fast=true);
    void setEZFloraProgram(InsteonID id, unsigned char program,
            unsigned char timer1,unsigned char timer2,unsigned char timer3,
            unsigned char timer4,unsigned char timer5,unsigned char timer6,
            unsigned char timer7,unsigned char timer8);
    void startProgram(InsteonID id, unsigned char program);
    void stopProgram(InsteonID id, unsigned char program);
    void startValve(InsteonID id, unsigned char valve);
    void stopValve(InsteonID id, unsigned char valve);


public:
	Insteon(char *serialPort);
	~Insteon();

    virtual void onInsteonMessage(unsigned char *buf);
    virtual void onInsteonMessageSent(InsteonID id, IInsteonMessage* cmd);

    void clearmodules_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void listmodules_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void addmodule_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void addezflora_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void setcontroller_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ramp_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void switch_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezflorasetprogram_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezflorastartprogram_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezflorastopprogram_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezflorastartvalve_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezflorastopvalve_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void ezfloraforcegetvalvestatus_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);
    void raw_callback(Dumais::JSON::JSON& json, Dumais::JSON::JSON& params);



    virtual void run();
    virtual std::string getName(){return "insteon";}

};

#endif

