#ifndef EVENTPROCESSOR_H
#define EVENTPROCESSOR_H

#include "RESTInterface.h"
#include "IScriptEngine.h"
#include <queue>
#include "Schedule.h"
#include "WeatherHelper.h"

class EventProcessor{
private:
    RESTInterface *mpRESTInterface;
    IScriptEngine *mpScriptEngine;
    std::queue<std::string> mMessageQueue;
    pthread_mutex_t mMessageQueueLock;
    pthread_cond_t mMessageQueueWaitCondition;
    Schedule* mpSchedule;
    WeatherHelper* mpWeatherHelper;
    ServiceProvider *mpServiceProvider;

    void processEvent(std::string str);
    void reloadScript();
    bool mNeedReloadScript;

public:
	EventProcessor(RESTInterface *p, Schedule *pSchedule, WeatherHelper *pWeather, ServiceProvider *sp);
	~EventProcessor();

    void processEvent(Dumais::JSON::JSON &message);
    void processSchedule(time_t t);
    bool timeSlice(); // will return false when it is time to shutdown the application
    void scheduleScriptReload();
    void checkSun(time_t t);
    
};

#endif

