#pragma once
#include <string>
#include <netlink/netlink.h>
#include <netlink/route/link.h>
#include <netlink/route/link/veth.h>
#include <netlink/route/link/bridge.h>
#include <netlink/route/addr.h>
#include <netlink/route/route.h>

#define strref const std::string&

class Veth
{
private:
    std::string name;
    std::string guestName;
    std::string hostName;
    struct nl_sock *s;
    struct rtnl_link *guest;
    struct rtnl_link *host;
    
    void setName(strref name);

public:
    enum Side
    {
        Host,
        Guest
    };

    Veth();
    ~Veth();
    Veth(strref id);
    void create(strref name, unsigned long pid);
    void destroy();
    void add_to_bridge(strref bridge);
    void remove_from_bridge(strref bridge);
    void up(Side side);
    void set_ip(Side side, strref ip);
    void setgw(strref ip);
};
