#include "Veth.h"
#include <iostream>

#define VSCTL "/usr/local/bin/ovs-vsctl"


Veth::Veth()
{
    this->name = "";
    this->s = nl_socket_alloc();
    if (nl_connect(this->s, NETLINK_ROUTE) < 0)
    {
        std::cerr << "Could not connect netlink socket\r\n";
        return;
    }
}

Veth::Veth(strref id)
{
    this->setName(id);
    this->s = nl_socket_alloc();
    if (nl_connect(this->s, NETLINK_ROUTE) < 0)
    {
        std::cerr << "Could not connect netlink socket\r\n";
        return;
    }

}

Veth::~Veth()
{
    rtnl_link_put(this->host);
    rtnl_link_put(this->guest);
    nl_close(this->s);
    nl_socket_free(this->s);
}

void Veth::setName(strref name)
{
    this->name = name;
    this->guestName = "eth0";
    this->hostName = "host"+this->name;
}

void Veth::create(strref name, unsigned long pid)
{
    this->host = rtnl_link_veth_alloc();
    if (!this->host)
    {
        std::cerr << "Could not create veth pair\r\n";
        return;
    }
    
    this->guest = rtnl_link_veth_get_peer(this->host);

    this->setName(name);

    rtnl_link_set_ns_pid(this->guest,pid);
    rtnl_link_set_name(this->guest, this->guestName.c_str());
    rtnl_link_set_name(this->host, this->hostName.c_str());
    

    if (rtnl_link_add(this->s, this->host, NLM_F_CREATE) < 0)
    {
        std::cerr << "Could not create veth pair\r\n";
        this->setName("");
        return;
    }

}

void Veth::up(Side side)
{
    struct nl_cache *links;
    if (!rtnl_link_alloc_cache(s,AF_UNSPEC,&links))
    {
        std::string lname;
        if (side == Guest) lname = this->guestName; else lname = this->hostName;
        struct rtnl_link *old= rtnl_link_get_by_name(links, lname.c_str());
        struct rtnl_link *request = rtnl_link_alloc();
        rtnl_link_set_flags(request, rtnl_link_str2flags("up"));
        rtnl_link_change(s, old, request, 0);
        rtnl_link_put(old);
        rtnl_link_put(request);
        nl_cache_free(links);
    }
}

void Veth::set_ip(Side side, strref ip)
{
    struct nl_cache *links;
    if (!rtnl_link_alloc_cache(s,AF_UNSPEC,&links))
    {
        std::string lname;
        if (side == Guest) lname = this->guestName; else lname = this->hostName;
        struct rtnl_link *link= rtnl_link_get_by_name(links, lname.c_str());
        struct rtnl_addr *addr = rtnl_addr_alloc();
        rtnl_addr_set_link(addr,link);

        struct nl_addr *nladdr;
        nl_addr_parse(ip.c_str(), AF_INET, &nladdr);
        rtnl_addr_set_local(addr, nladdr);
        rtnl_addr_add(s, addr, 0);
        rtnl_addr_put(addr);

        rtnl_link_put(link);
        nl_cache_free(links);
    }
}

void Veth::add_to_bridge(strref bridge)
{
    std::string cmd = VSCTL;
    cmd+= " add-port " + bridge + " " + this->hostName;
    //TODO: this is ugly. Should talk to ovsdb directly
    system(cmd.c_str());
}

void Veth::remove_from_bridge(strref bridge)
{
    std::string cmd = VSCTL;
    cmd+= " del-port " + bridge + " " + this->hostName;
    //TODO: this is ugly. Should talk to ovsdb directly
    system(cmd.c_str());
}

void Veth::destroy()
{
    if (!this->host) return;
    rtnl_link_delete(this->s, this->host);
}

void Veth::setgw(strref ip)
{
    struct rtnl_route *route = rtnl_route_alloc();
    rtnl_route_set_iif(route, AF_INET);

    rtnl_route_set_scope(route, RT_SCOPE_UNIVERSE);
    rtnl_route_set_table(route, RT_TABLE_MAIN);
    rtnl_route_set_protocol(route, RTPROT_STATIC);

    nl_addr* addr;
    nl_addr_parse("0.0.0.0/0", AF_INET, &addr);
    rtnl_route_set_dst(route, addr);

    struct rtnl_nexthop* hop = rtnl_route_nh_alloc();
    nl_addr* gw;
    nl_addr_parse(ip.c_str(), AF_INET, &gw);
    rtnl_route_nh_set_gateway(hop, gw);
    rtnl_route_add_nexthop(route, hop);

    rtnl_route_add(this->s, route, 0);
    rtnl_route_put(route);
}
