#include "Settings.h"
#include <iostream>

Settings::Settings(strref file)
{
    char* buffer = new char[1024];
    memset(buffer,0,1024);
    FILE *f = fopen(file.c_str(),"r");
    if (f)
    {
        size_t size = fread(buffer,1024,1,f);
        fclose(f);

        std::regex r("(.*): *([^\\r]*)",std::regex_constants::icase);
        std::smatch matches;
        std::stringstream ss(buffer);
        std::string line;
        while (getline(ss,line,'\n'))
        {   
            if (line == "") continue;
            if (std::regex_search(line,matches,r))
            {
                settings[matches[1]] = matches[2];
            }
        }
    }
    else
    {
        std::cerr << "Could not open config file " << file << "\r\n";
    }   
}

std::string Settings::get(strref key, strref defaultValue)
{
    if (settings.count(key) == 0) return defaultValue;
    return settings[key];
}

