#include "MountPoint.h"
#include <sys/mount.h>
#include <iostream>

MountPoint::MountPoint(strref source, strref target, strref fs, strref data, int options)
{
    this->source = source;
    this->target = target;
    this->fs = fs;
    this->data = data;
    this->options = options;
}

MountPoint::~MountPoint()
{
    this->umount();
}

bool MountPoint::mount()
{
    if (::mount(this->source.c_str(),this->target.c_str(),this->fs.c_str(),this->options,this->data.c_str()))
    {
        int error = errno;
        if (error == 16)
        {
            std::cerr << "ERROR: Mountpoint " << target << " is already mounted. Are you sure this container is not already running?"
                " Please unmount this mountpoint or make sure the container is not already running\r\n"; 
        }
        else
        {
            std::cerr << "mount " << target << " returned " << error << "\r\n";
        }
        return false;
    }
    return true;
}

void MountPoint::umount()
{
    ::umount(this->target.c_str());
}

