#pragma once
#include <string>
#include "Settings.h"
#include "CGroup.h"
#include "MountPoint.h"
#include "Veth.h"

#define strref const std::string&

struct SharedData
{
    bool ready;
};

class Container
{
public:
    Container(strref path, Settings *s);
    void start();
    void clean();

    void run_child();
private:
    std::string chrootPath;
    Settings* settings;
    CGroup* cgroup;
    std::vector<MountPoint*> mountPoints;
    SharedData* data;
    Veth* veth;
    std::string id;

    int make_chroot();
    int make_cgroup();
    int configure_cgroup();
    int start_process();
    bool mountfs(strref source, strref target, strref fs, strref data, int options);
    bool umountfs(strref target);

};
