#include "CGroup.h"
#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#define CGROUPFS "/sys/fs/cgroup"

CGroup::CGroup(strref name)
{
    this->cgroupID = "";
    struct stat buf;
    int err = stat(CGROUPFS, &buf);
    if (err < 0)
    {
        std::cerr << "Was expecting cgroup fs in " << CGROUPFS << " but it was not found ("<< buf.st_dev<<")\r\n";
        return;
    }

    int retry = 0;
    std::string realname = name;
    while (mkdir(std::string(CGROUPFS "/memory/" + realname).c_str(),0740) == -1)
    {
        realname += "x";
        retry++;
        if (retry > 10)
        {
            std::cerr << "Could not create cgroup\r\n";
            return;
        }
    }
    mkdir(std::string(CGROUPFS "/cpu/" + realname).c_str(),0740);
    this->cgroupID = realname;
}

CGroup::~CGroup()
{
    rmdir(getPath("memory").c_str());
    rmdir(getPath("cpu").c_str());
}

bool CGroup::is_valid()
{
    return (this->cgroupID != "");
}

void CGroup::add_task(unsigned int pid)
{
    write_file("memory","tasks",std::to_string(pid));
    write_file("cpu","tasks",std::to_string(pid));
}

std::string CGroup::getPath(strref submodule)
{
    return CGROUPFS "/" + submodule + "/" + this->cgroupID;        
}

void CGroup::write_file(strref submodule, strref file, strref data)
{
    std::string str = getPath(submodule) + "/" + file;
    FILE* f = fopen(str.c_str(),"w");
    if (f)
    {
        fwrite(data.c_str(),data.size(),1,f);
        fclose(f);    
    }
    else
    {
        std::cerr << "Could not write into " << str;
    }
}
